// src/index.tsx
import React from "react";
import { z } from "zod";
var PADDING_SCHEMA = z.object({
  top: z.number(),
  bottom: z.number(),
  right: z.number(),
  left: z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var AvatarPropsSchema = z.object({
  style: z.object({
    textAlign: z.enum(["left", "center", "right"]).optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: z.object({
    size: z.number().gt(0).optional().nullable(),
    shape: z.enum(["circle", "square", "rounded"]).optional().nullable(),
    imageUrl: z.string().optional().nullable(),
    alt: z.string().optional().nullable()
  }).optional().nullable()
});
function getBorderRadius(shape, size) {
  switch (shape) {
    case "rounded":
      return size * 0.125;
    case "circle":
      return size;
    case "square":
    default:
      return void 0;
  }
}
var AvatarPropsDefaults = {
  size: 64,
  imageUrl: "",
  alt: "",
  shape: "square"
};
function Avatar({ style, props }) {
  var _a, _b, _c, _d, _e;
  const size = (_a = props == null ? void 0 : props.size) != null ? _a : AvatarPropsDefaults.size;
  const imageUrl = (_b = props == null ? void 0 : props.imageUrl) != null ? _b : AvatarPropsDefaults.imageUrl;
  const alt = (_c = props == null ? void 0 : props.alt) != null ? _c : AvatarPropsDefaults.alt;
  const shape = (_d = props == null ? void 0 : props.shape) != null ? _d : AvatarPropsDefaults.shape;
  const sectionStyle = {
    textAlign: (_e = style == null ? void 0 : style.textAlign) != null ? _e : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  return /* @__PURE__ */ React.createElement("div", { style: sectionStyle }, /* @__PURE__ */ React.createElement(
    "img",
    {
      alt,
      src: imageUrl,
      height: size,
      width: size,
      style: {
        outline: "none",
        border: "none",
        textDecoration: "none",
        objectFit: "cover",
        height: size,
        width: size,
        maxWidth: "100%",
        display: "inline-block",
        verticalAlign: "middle",
        textAlign: "center",
        borderRadius: getBorderRadius(shape, size)
      }
    }
  ));
}
export {
  Avatar,
  AvatarPropsDefaults,
  AvatarPropsSchema
};
