"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.tsx
var src_exports = {};
__export(src_exports, {
  Container: () => Container,
  ContainerPropsSchema: () => ContainerPropsSchema
});
module.exports = __toCommonJS(src_exports);
var import_react = __toESM(require("react"));
var import_zod = require("zod");
var COLOR_SCHEMA = import_zod.z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = import_zod.z.object({
  top: import_zod.z.number(),
  bottom: import_zod.z.number(),
  right: import_zod.z.number(),
  left: import_zod.z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var ContainerPropsSchema = import_zod.z.object({
  style: import_zod.z.object({
    backgroundColor: COLOR_SCHEMA,
    borderColor: COLOR_SCHEMA,
    borderRadius: import_zod.z.number().optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable()
});
function getBorder(style) {
  if (!style || !style.borderColor) {
    return void 0;
  }
  return `1px solid ${style.borderColor}`;
}
function Container({ style, children }) {
  var _a, _b;
  const wStyle = {
    backgroundColor: (_a = style == null ? void 0 : style.backgroundColor) != null ? _a : void 0,
    border: getBorder(style),
    borderRadius: (_b = style == null ? void 0 : style.borderRadius) != null ? _b : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  if (!children) {
    return /* @__PURE__ */ import_react.default.createElement("div", { style: wStyle });
  }
  return /* @__PURE__ */ import_react.default.createElement("div", { style: wStyle }, children);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Container,
  ContainerPropsSchema
});
