// src/index.tsx
import React from "react";
import { z } from "zod";
var COLOR_SCHEMA = z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = z.object({
  top: z.number(),
  bottom: z.number(),
  right: z.number(),
  left: z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var ContainerPropsSchema = z.object({
  style: z.object({
    backgroundColor: COLOR_SCHEMA,
    borderColor: COLOR_SCHEMA,
    borderRadius: z.number().optional().nullable(),
    padding: PADDING_SCHEMA
  }).optional().nullable()
});
function getBorder(style) {
  if (!style || !style.borderColor) {
    return void 0;
  }
  return `1px solid ${style.borderColor}`;
}
function Container({ style, children }) {
  var _a, _b;
  const wStyle = {
    backgroundColor: (_a = style == null ? void 0 : style.backgroundColor) != null ? _a : void 0,
    border: getBorder(style),
    borderRadius: (_b = style == null ? void 0 : style.borderRadius) != null ? _b : void 0,
    padding: getPadding(style == null ? void 0 : style.padding)
  };
  if (!children) {
    return /* @__PURE__ */ React.createElement("div", { style: wStyle });
  }
  return /* @__PURE__ */ React.createElement("div", { style: wStyle }, children);
}
export {
  Container,
  ContainerPropsSchema
};
