// src/index.tsx
import React from "react";
import { z } from "zod";
var COLOR_SCHEMA = z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var PADDING_SCHEMA = z.object({
  top: z.number(),
  bottom: z.number(),
  right: z.number(),
  left: z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var DividerPropsSchema = z.object({
  style: z.object({
    backgroundColor: COLOR_SCHEMA,
    padding: PADDING_SCHEMA
  }).optional().nullable(),
  props: z.object({
    lineColor: COLOR_SCHEMA,
    lineHeight: z.number().optional().nullable()
  }).optional().nullable()
});
var DividerPropsDefaults = {
  lineHeight: 1,
  lineColor: "#333333"
};
function Divider({ style, props }) {
  var _a, _b, _c;
  const st = {
    padding: getPadding(style == null ? void 0 : style.padding),
    backgroundColor: (_a = style == null ? void 0 : style.backgroundColor) != null ? _a : void 0
  };
  const borderTopWidth = (_b = props == null ? void 0 : props.lineHeight) != null ? _b : DividerPropsDefaults.lineHeight;
  const borderTopColor = (_c = props == null ? void 0 : props.lineColor) != null ? _c : DividerPropsDefaults.lineColor;
  return /* @__PURE__ */ React.createElement("div", { style: st }, /* @__PURE__ */ React.createElement(
    "hr",
    {
      style: {
        width: "100%",
        border: "none",
        borderTop: `${borderTopWidth}px solid ${borderTopColor}`,
        margin: 0
      }
    }
  ));
}
export {
  Divider,
  DividerPropsDefaults,
  DividerPropsSchema
};
