// src/index.tsx
import React from "react";
import { z } from "zod";
var PADDING_SCHEMA = z.object({
  top: z.number(),
  bottom: z.number(),
  right: z.number(),
  left: z.number()
}).optional().nullable();
var getPadding = (padding) => padding ? `${padding.top}px ${padding.right}px ${padding.bottom}px ${padding.left}px` : void 0;
var ImagePropsSchema = z.object({
  style: z.object({
    padding: PADDING_SCHEMA,
    backgroundColor: z.string().regex(/^#[0-9a-fA-F]{6}$/).optional().nullable(),
    textAlign: z.enum(["center", "left", "right"]).optional().nullable()
  }).optional().nullable(),
  props: z.object({
    width: z.number().optional().nullable(),
    height: z.number().optional().nullable(),
    url: z.string().optional().nullable(),
    alt: z.string().optional().nullable(),
    linkHref: z.string().optional().nullable(),
    contentAlignment: z.enum(["top", "middle", "bottom"]).optional().nullable()
  }).optional().nullable()
});
function Image({ style, props }) {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  const sectionStyle = {
    padding: getPadding(style == null ? void 0 : style.padding),
    backgroundColor: (_a = style == null ? void 0 : style.backgroundColor) != null ? _a : void 0,
    textAlign: (_b = style == null ? void 0 : style.textAlign) != null ? _b : void 0
  };
  const linkHref = (_c = props == null ? void 0 : props.linkHref) != null ? _c : null;
  const width = (_d = props == null ? void 0 : props.width) != null ? _d : void 0;
  const height = (_e = props == null ? void 0 : props.height) != null ? _e : void 0;
  const imageElement = /* @__PURE__ */ React.createElement(
    "img",
    {
      alt: (_f = props == null ? void 0 : props.alt) != null ? _f : "",
      src: (_g = props == null ? void 0 : props.url) != null ? _g : "",
      width,
      height,
      style: {
        width,
        height,
        outline: "none",
        border: "none",
        textDecoration: "none",
        verticalAlign: (_h = props == null ? void 0 : props.contentAlignment) != null ? _h : "middle",
        display: "inline-block",
        maxWidth: "100%"
      }
    }
  );
  if (!linkHref) {
    return /* @__PURE__ */ React.createElement("div", { style: sectionStyle }, imageElement);
  }
  return /* @__PURE__ */ React.createElement("div", { style: sectionStyle }, /* @__PURE__ */ React.createElement("a", { href: linkHref, style: { textDecoration: "none" }, target: "_blank" }, imageElement));
}
export {
  Image,
  ImagePropsSchema
};
