"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  buildBlockComponent: () => buildBlockComponent,
  buildBlockConfigurationDictionary: () => buildBlockConfigurationDictionary,
  buildBlockConfigurationSchema: () => buildBlockConfigurationSchema
});
module.exports = __toCommonJS(src_exports);

// src/builders/buildBlockComponent.tsx
var import_react = __toESM(require("react"));
function buildBlockComponent(blocks) {
  return function BlockComponent({ type, data }) {
    const Component = blocks[type].Component;
    return /* @__PURE__ */ import_react.default.createElement(Component, __spreadValues({}, data));
  };
}

// src/builders/buildBlockConfigurationSchema.ts
var import_zod = require("zod");
function buildBlockConfigurationSchema(blocks) {
  const blockObjects = Object.keys(blocks).map(
    (type) => import_zod.z.object({
      type: import_zod.z.literal(type),
      data: blocks[type].schema
    })
  );
  return import_zod.z.discriminatedUnion("type", blockObjects).transform((v) => v);
}

// src/builders/buildBlockConfigurationDictionary.ts
function buildBlockConfigurationDictionary(blocks) {
  return blocks;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  buildBlockComponent,
  buildBlockConfigurationDictionary,
  buildBlockConfigurationSchema
});
