var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};

// src/builders/buildBlockComponent.tsx
import React from "react";
function buildBlockComponent(blocks) {
  return function BlockComponent({ type, data }) {
    const Component = blocks[type].Component;
    return /* @__PURE__ */ React.createElement(Component, __spreadValues({}, data));
  };
}

// src/builders/buildBlockConfigurationSchema.ts
import { z } from "zod";
function buildBlockConfigurationSchema(blocks) {
  const blockObjects = Object.keys(blocks).map(
    (type) => z.object({
      type: z.literal(type),
      data: blocks[type].schema
    })
  );
  return z.discriminatedUnion("type", blockObjects).transform((v) => v);
}

// src/builders/buildBlockConfigurationDictionary.ts
function buildBlockConfigurationDictionary(blocks) {
  return blocks;
}
export {
  buildBlockComponent,
  buildBlockConfigurationDictionary,
  buildBlockConfigurationSchema
};
