"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Reader: () => Reader,
  ReaderBlock: () => ReaderBlock,
  ReaderBlockSchema: () => ReaderBlockSchema,
  ReaderDocumentSchema: () => ReaderDocumentSchema,
  renderToStaticMarkup: () => renderToStaticMarkup
});
module.exports = __toCommonJS(src_exports);

// src/renderers/renderToStaticMarkup.tsx
var import_react5 = __toESM(require("react"));
var import_server = require("react-dom/server");

// src/Reader/core.tsx
var import_react4 = __toESM(require("react"));
var import_zod4 = require("zod");
var import_block_avatar = require("@usewaypoint/block-avatar");
var import_block_button = require("@usewaypoint/block-button");
var import_block_divider = require("@usewaypoint/block-divider");
var import_block_heading = require("@usewaypoint/block-heading");
var import_block_html = require("@usewaypoint/block-html");
var import_block_image = require("@usewaypoint/block-image");
var import_block_spacer = require("@usewaypoint/block-spacer");
var import_block_text = require("@usewaypoint/block-text");
var import_document_core = require("@usewaypoint/document-core");

// src/blocks/ColumnsContainer/ColumnsContainerPropsSchema.ts
var import_zod = require("zod");
var import_block_columns_container = require("@usewaypoint/block-columns-container");
var BasePropsShape = import_block_columns_container.ColumnsContainerPropsSchema.shape.props.unwrap().unwrap().shape;
var ColumnsContainerPropsSchema = import_zod.z.object({
  style: import_block_columns_container.ColumnsContainerPropsSchema.shape.style,
  props: import_zod.z.object(__spreadProps(__spreadValues({}, BasePropsShape), {
    columns: import_zod.z.tuple([
      import_zod.z.object({ childrenIds: import_zod.z.array(import_zod.z.string()) }),
      import_zod.z.object({ childrenIds: import_zod.z.array(import_zod.z.string()) }),
      import_zod.z.object({ childrenIds: import_zod.z.array(import_zod.z.string()) })
    ])
  })).optional().nullable()
});
var ColumnsContainerPropsSchema_default = ColumnsContainerPropsSchema;

// src/blocks/ColumnsContainer/ColumnsContainerReader.tsx
var import_react = __toESM(require("react"));
var import_block_columns_container2 = require("@usewaypoint/block-columns-container");
function ColumnsContainerReader({ style, props }) {
  const _a = props != null ? props : {}, { columns } = _a, restProps = __objRest(_a, ["columns"]);
  let cols = void 0;
  if (columns) {
    cols = columns.map((col) => col.childrenIds.map((childId) => /* @__PURE__ */ import_react.default.createElement(ReaderBlock, { key: childId, id: childId })));
  }
  return /* @__PURE__ */ import_react.default.createElement(import_block_columns_container2.ColumnsContainer, { props: restProps, columns: cols, style });
}

// src/blocks/Container/ContainerPropsSchema.tsx
var import_zod2 = require("zod");
var import_block_container = require("@usewaypoint/block-container");
var ContainerPropsSchema = import_zod2.z.object({
  style: import_block_container.ContainerPropsSchema.shape.style,
  props: import_zod2.z.object({
    childrenIds: import_zod2.z.array(import_zod2.z.string()).optional().nullable()
  }).optional().nullable()
});

// src/blocks/Container/ContainerReader.tsx
var import_react2 = __toESM(require("react"));
var import_block_container2 = require("@usewaypoint/block-container");
function ContainerReader({ style, props }) {
  var _a;
  const childrenIds = (_a = props == null ? void 0 : props.childrenIds) != null ? _a : [];
  return /* @__PURE__ */ import_react2.default.createElement(import_block_container2.Container, { style }, childrenIds.map((childId) => /* @__PURE__ */ import_react2.default.createElement(ReaderBlock, { key: childId, id: childId })));
}

// src/blocks/EmailLayout/EmailLayoutPropsSchema.tsx
var import_zod3 = require("zod");
var COLOR_SCHEMA = import_zod3.z.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var FONT_FAMILY_SCHEMA = import_zod3.z.enum([
  "MODERN_SANS",
  "BOOK_SANS",
  "ORGANIC_SANS",
  "GEOMETRIC_SANS",
  "HEAVY_SANS",
  "ROUNDED_SANS",
  "MODERN_SERIF",
  "BOOK_SERIF",
  "MONOSPACE"
]).nullable().optional();
var EmailLayoutPropsSchema = import_zod3.z.object({
  backdropColor: COLOR_SCHEMA,
  borderColor: COLOR_SCHEMA,
  borderRadius: import_zod3.z.number().optional().nullable(),
  canvasColor: COLOR_SCHEMA,
  textColor: COLOR_SCHEMA,
  fontFamily: FONT_FAMILY_SCHEMA,
  childrenIds: import_zod3.z.array(import_zod3.z.string()).optional().nullable()
});

// src/blocks/EmailLayout/EmailLayoutReader.tsx
var import_react3 = __toESM(require("react"));
function getFontFamily(fontFamily) {
  const f = fontFamily != null ? fontFamily : "MODERN_SANS";
  switch (f) {
    case "MODERN_SANS":
      return '"Helvetica Neue", "Arial Nova", "Nimbus Sans", Arial, sans-serif';
    case "BOOK_SANS":
      return 'Optima, Candara, "Noto Sans", source-sans-pro, sans-serif';
    case "ORGANIC_SANS":
      return 'Seravek, "Gill Sans Nova", Ubuntu, Calibri, "DejaVu Sans", source-sans-pro, sans-serif';
    case "GEOMETRIC_SANS":
      return 'Avenir, "Avenir Next LT Pro", Montserrat, Corbel, "URW Gothic", source-sans-pro, sans-serif';
    case "HEAVY_SANS":
      return 'Bahnschrift, "DIN Alternate", "Franklin Gothic Medium", "Nimbus Sans Narrow", sans-serif-condensed, sans-serif';
    case "ROUNDED_SANS":
      return 'ui-rounded, "Hiragino Maru Gothic ProN", Quicksand, Comfortaa, Manjari, "Arial Rounded MT Bold", Calibri, source-sans-pro, sans-serif';
    case "MODERN_SERIF":
      return 'Charter, "Bitstream Charter", "Sitka Text", Cambria, serif';
    case "BOOK_SERIF":
      return '"Iowan Old Style", "Palatino Linotype", "URW Palladio L", P052, serif';
    case "MONOSPACE":
      return '"Nimbus Mono PS", "Courier New", "Cutive Mono", monospace';
  }
}
function getBorder({ borderColor }) {
  if (!borderColor) {
    return void 0;
  }
  return `1px solid ${borderColor}`;
}
function EmailLayoutReader(props) {
  var _a, _b, _c, _d, _e;
  const childrenIds = (_a = props.childrenIds) != null ? _a : [];
  return /* @__PURE__ */ import_react3.default.createElement(
    "div",
    {
      style: {
        backgroundColor: (_b = props.backdropColor) != null ? _b : "#F5F5F5",
        color: (_c = props.textColor) != null ? _c : "#262626",
        fontFamily: getFontFamily(props.fontFamily),
        fontSize: "16px",
        fontWeight: "400",
        letterSpacing: "0.15008px",
        lineHeight: "1.5",
        margin: "0",
        padding: "32px 0",
        minHeight: "100%",
        width: "100%"
      }
    },
    /* @__PURE__ */ import_react3.default.createElement(
      "table",
      {
        align: "center",
        width: "100%",
        style: {
          margin: "0 auto",
          maxWidth: "600px",
          backgroundColor: (_d = props.canvasColor) != null ? _d : "#FFFFFF",
          borderRadius: (_e = props.borderRadius) != null ? _e : void 0,
          border: getBorder(props)
        },
        role: "presentation",
        cellSpacing: "0",
        cellPadding: "0",
        border: 0
      },
      /* @__PURE__ */ import_react3.default.createElement("tbody", null, /* @__PURE__ */ import_react3.default.createElement("tr", { style: { width: "100%" } }, /* @__PURE__ */ import_react3.default.createElement("td", null, childrenIds.map((childId) => /* @__PURE__ */ import_react3.default.createElement(ReaderBlock, { key: childId, id: childId })))))
    )
  );
}

// src/Reader/core.tsx
var ReaderContext = (0, import_react4.createContext)({});
function useReaderDocument() {
  return (0, import_react4.useContext)(ReaderContext);
}
var READER_DICTIONARY = (0, import_document_core.buildBlockConfigurationDictionary)({
  ColumnsContainer: {
    schema: ColumnsContainerPropsSchema_default,
    Component: ColumnsContainerReader
  },
  Container: {
    schema: ContainerPropsSchema,
    Component: ContainerReader
  },
  EmailLayout: {
    schema: EmailLayoutPropsSchema,
    Component: EmailLayoutReader
  },
  //
  Avatar: {
    schema: import_block_avatar.AvatarPropsSchema,
    Component: import_block_avatar.Avatar
  },
  Button: {
    schema: import_block_button.ButtonPropsSchema,
    Component: import_block_button.Button
  },
  Divider: {
    schema: import_block_divider.DividerPropsSchema,
    Component: import_block_divider.Divider
  },
  Heading: {
    schema: import_block_heading.HeadingPropsSchema,
    Component: import_block_heading.Heading
  },
  Html: {
    schema: import_block_html.HtmlPropsSchema,
    Component: import_block_html.Html
  },
  Image: {
    schema: import_block_image.ImagePropsSchema,
    Component: import_block_image.Image
  },
  Spacer: {
    schema: import_block_spacer.SpacerPropsSchema,
    Component: import_block_spacer.Spacer
  },
  Text: {
    schema: import_block_text.TextPropsSchema,
    Component: import_block_text.Text
  }
});
var ReaderBlockSchema = (0, import_document_core.buildBlockConfigurationSchema)(READER_DICTIONARY);
var ReaderDocumentSchema = import_zod4.z.record(import_zod4.z.string(), ReaderBlockSchema);
var BaseReaderBlock = (0, import_document_core.buildBlockComponent)(READER_DICTIONARY);
function ReaderBlock({ id }) {
  const document = useReaderDocument();
  return /* @__PURE__ */ import_react4.default.createElement(BaseReaderBlock, __spreadValues({}, document[id]));
}
function Reader({ document, rootBlockId }) {
  return /* @__PURE__ */ import_react4.default.createElement(ReaderContext.Provider, { value: document }, /* @__PURE__ */ import_react4.default.createElement(ReaderBlock, { id: rootBlockId }));
}

// src/renderers/renderToStaticMarkup.tsx
function renderToStaticMarkup(document, { rootBlockId }) {
  return "<!DOCTYPE html>" + (0, import_server.renderToStaticMarkup)(
    /* @__PURE__ */ import_react5.default.createElement("html", null, /* @__PURE__ */ import_react5.default.createElement("body", null, /* @__PURE__ */ import_react5.default.createElement(Reader, { document, rootBlockId })))
  );
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Reader,
  ReaderBlock,
  ReaderBlockSchema,
  ReaderDocumentSchema,
  renderToStaticMarkup
});
